<?php declare(strict_types=1);
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: src/Tracing/FederatedTracing/reports.proto

namespace Nuwave\Lighthouse\Tracing\FederatedTracing\Proto;

use Google\Protobuf\Internal\GPBUtil;

/**
 * Generated from protobuf message <code>QueryLatencyStats</code>.
 */
class QueryLatencyStats extends \Google\Protobuf\Internal\Message
{
    /**
     * The latencies of all non-cached requests, so the sum of all counts should equal request_count minus cache_hits.
     * This is an array of counts within a logarithmic range of 384 latency buckets. To calculate the bucket from a
     * microsecond, use the formula: max(0, min(ceil(ln(x)/ln(1.1)), 383)). So for example, 323424 microseconds (323.424
     * ms) corresponds to bucket 134. Buckets can be skipped using a negative number, so one request on that bucket could
     * be represented as [-134, 1] (skip buckets numbered 0 to 133 and set a 1 in bucket 134).
     *
     * Generated from protobuf field <code>repeated sint64 latency_count = 13 [json_name = "latencyCount"];</code>
     */
    private $latency_count;

    /**
     * The total number of requests, including both cache hits and cache misses.
     *
     * Generated from protobuf field <code>uint64 request_count = 2 [json_name = "requestCount"];</code>
     */
    protected $request_count = 0;

    /**
     * The total number of requests that were cache hits. Each request should be represented in cache_latency_count.
     *
     * Generated from protobuf field <code>uint64 cache_hits = 3 [json_name = "cacheHits"];</code>
     */
    protected $cache_hits = 0;

    /** Generated from protobuf field <code>uint64 persisted_query_hits = 4 [json_name = "persistedQueryHits"];</code> */
    protected $persisted_query_hits = 0;

    /** Generated from protobuf field <code>uint64 persisted_query_misses = 5 [json_name = "persistedQueryMisses"];</code> */
    protected $persisted_query_misses = 0;

    /**
     * This array includes the latency buckets for all operations included in cache_hits
     * See comment on latency_count for details.
     *
     * Generated from protobuf field <code>repeated sint64 cache_latency_count = 14 [json_name = "cacheLatencyCount"];</code>
     */
    private $cache_latency_count;

    /**
     * Paths and counts for each error. The total number of requests with errors within this object should be the same as
     * requests_with_errors_count below.
     *
     * Generated from protobuf field <code>.PathErrorStats root_error_stats = 7 [json_name = "rootErrorStats"];</code>
     */
    protected $root_error_stats;

    /**
     * Total number of requests that contained at least one error.
     *
     * Generated from protobuf field <code>uint64 requests_with_errors_count = 8 [json_name = "requestsWithErrorsCount"];</code>
     */
    protected $requests_with_errors_count = 0;

    /** Generated from protobuf field <code>repeated sint64 public_cache_ttl_count = 15 [json_name = "publicCacheTtlCount"];</code> */
    private $public_cache_ttl_count;

    /** Generated from protobuf field <code>repeated sint64 private_cache_ttl_count = 16 [json_name = "privateCacheTtlCount"];</code> */
    private $private_cache_ttl_count;

    /** Generated from protobuf field <code>uint64 registered_operation_count = 11 [json_name = "registeredOperationCount"];</code> */
    protected $registered_operation_count = 0;

    /** Generated from protobuf field <code>uint64 forbidden_operation_count = 12 [json_name = "forbiddenOperationCount"];</code> */
    protected $forbidden_operation_count = 0;

    /**
     * The number of requests that were executed without field-level
     * instrumentation (and thus do not contribute to `observed_execution_count`
     * fields on this message's cousin-twice-removed FieldStats).
     *
     * Generated from protobuf field <code>uint64 requests_without_field_instrumentation = 17 [json_name = "requestsWithoutFieldInstrumentation"];</code>
     */
    protected $requests_without_field_instrumentation = 0;

    /**
     * Constructor.
     *
     * @param  array  $data {
     *     Optional. Data for populating the Message object.
     *
     *     @var array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $latency_count
     *           The latencies of all non-cached requests, so the sum of all counts should equal request_count minus cache_hits.
     *           This is an array of counts within a logarithmic range of 384 latency buckets. To calculate the bucket from a
     *           microsecond, use the formula: max(0, min(ceil(ln(x)/ln(1.1)), 383)). So for example, 323424 microseconds (323.424
     *           ms) corresponds to bucket 134. Buckets can be skipped using a negative number, so one request on that bucket could
     *           be represented as [-134, 1] (skip buckets numbered 0 to 133 and set a 1 in bucket 134).
     *     @var int|string $request_count
     *           The total number of requests, including both cache hits and cache misses
     *     @var int|string $cache_hits
     *           The total number of requests that were cache hits. Each request should be represented in cache_latency_count
     *     @var int|string $persisted_query_hits
     *     @var int|string $persisted_query_misses
     *     @var array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $cache_latency_count
     *           This array includes the latency buckets for all operations included in cache_hits
     *           See comment on latency_count for details.
     *     @var \Nuwave\Lighthouse\Tracing\FederatedTracing\Proto\PathErrorStats $root_error_stats
     *           Paths and counts for each error. The total number of requests with errors within this object should be the same as
     *           requests_with_errors_count below.
     *     @var int|string $requests_with_errors_count
     *           Total number of requests that contained at least one error
     *     @var array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $public_cache_ttl_count
     *     @var array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $private_cache_ttl_count
     *     @var int|string $registered_operation_count
     *     @var int|string $forbidden_operation_count
     *     @var int|string $requests_without_field_instrumentation
     *           The number of requests that were executed without field-level
     *           instrumentation (and thus do not contribute to `observed_execution_count`
     *           fields on this message's cousin-twice-removed FieldStats).
     * }
     */
    public function __construct($data = null)
    {
        \Nuwave\Lighthouse\Tracing\FederatedTracing\Proto\Metadata\Reports::initOnce();
        parent::__construct($data);
    }

    /**
     * The latencies of all non-cached requests, so the sum of all counts should equal request_count minus cache_hits.
     * This is an array of counts within a logarithmic range of 384 latency buckets. To calculate the bucket from a
     * microsecond, use the formula: max(0, min(ceil(ln(x)/ln(1.1)), 383)). So for example, 323424 microseconds (323.424
     * ms) corresponds to bucket 134. Buckets can be skipped using a negative number, so one request on that bucket could
     * be represented as [-134, 1] (skip buckets numbered 0 to 133 and set a 1 in bucket 134).
     *
     * Generated from protobuf field <code>repeated sint64 latency_count = 13 [json_name = "latencyCount"];</code>
     *
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLatencyCount()
    {
        return $this->latency_count;
    }

    /**
     * The latencies of all non-cached requests, so the sum of all counts should equal request_count minus cache_hits.
     * This is an array of counts within a logarithmic range of 384 latency buckets. To calculate the bucket from a
     * microsecond, use the formula: max(0, min(ceil(ln(x)/ln(1.1)), 383)). So for example, 323424 microseconds (323.424
     * ms) corresponds to bucket 134. Buckets can be skipped using a negative number, so one request on that bucket could
     * be represented as [-134, 1] (skip buckets numbered 0 to 133 and set a 1 in bucket 134).
     *
     * Generated from protobuf field <code>repeated sint64 latency_count = 13 [json_name = "latencyCount"];</code>
     *
     * @param  array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField  $var
     *
     * @return $this
     */
    public function setLatencyCount($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::SINT64);
        $this->latency_count = $arr;

        return $this;
    }

    /**
     * The total number of requests, including both cache hits and cache misses.
     *
     * Generated from protobuf field <code>uint64 request_count = 2 [json_name = "requestCount"];</code>
     *
     * @return int|string
     */
    public function getRequestCount()
    {
        return $this->request_count;
    }

    /**
     * The total number of requests, including both cache hits and cache misses.
     *
     * Generated from protobuf field <code>uint64 request_count = 2 [json_name = "requestCount"];</code>
     *
     * @param  int|string  $var
     *
     * @return $this
     */
    public function setRequestCount($var)
    {
        GPBUtil::checkUint64($var);
        $this->request_count = $var;

        return $this;
    }

    /**
     * The total number of requests that were cache hits. Each request should be represented in cache_latency_count.
     *
     * Generated from protobuf field <code>uint64 cache_hits = 3 [json_name = "cacheHits"];</code>
     *
     * @return int|string
     */
    public function getCacheHits()
    {
        return $this->cache_hits;
    }

    /**
     * The total number of requests that were cache hits. Each request should be represented in cache_latency_count.
     *
     * Generated from protobuf field <code>uint64 cache_hits = 3 [json_name = "cacheHits"];</code>
     *
     * @param  int|string  $var
     *
     * @return $this
     */
    public function setCacheHits($var)
    {
        GPBUtil::checkUint64($var);
        $this->cache_hits = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>uint64 persisted_query_hits = 4 [json_name = "persistedQueryHits"];</code>.
     *
     * @return int|string
     */
    public function getPersistedQueryHits()
    {
        return $this->persisted_query_hits;
    }

    /**
     * Generated from protobuf field <code>uint64 persisted_query_hits = 4 [json_name = "persistedQueryHits"];</code>.
     *
     * @param  int|string  $var
     *
     * @return $this
     */
    public function setPersistedQueryHits($var)
    {
        GPBUtil::checkUint64($var);
        $this->persisted_query_hits = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>uint64 persisted_query_misses = 5 [json_name = "persistedQueryMisses"];</code>.
     *
     * @return int|string
     */
    public function getPersistedQueryMisses()
    {
        return $this->persisted_query_misses;
    }

    /**
     * Generated from protobuf field <code>uint64 persisted_query_misses = 5 [json_name = "persistedQueryMisses"];</code>.
     *
     * @param  int|string  $var
     *
     * @return $this
     */
    public function setPersistedQueryMisses($var)
    {
        GPBUtil::checkUint64($var);
        $this->persisted_query_misses = $var;

        return $this;
    }

    /**
     * This array includes the latency buckets for all operations included in cache_hits
     * See comment on latency_count for details.
     *
     * Generated from protobuf field <code>repeated sint64 cache_latency_count = 14 [json_name = "cacheLatencyCount"];</code>
     *
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCacheLatencyCount()
    {
        return $this->cache_latency_count;
    }

    /**
     * This array includes the latency buckets for all operations included in cache_hits
     * See comment on latency_count for details.
     *
     * Generated from protobuf field <code>repeated sint64 cache_latency_count = 14 [json_name = "cacheLatencyCount"];</code>
     *
     * @param  array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField  $var
     *
     * @return $this
     */
    public function setCacheLatencyCount($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::SINT64);
        $this->cache_latency_count = $arr;

        return $this;
    }

    /**
     * Paths and counts for each error. The total number of requests with errors within this object should be the same as
     * requests_with_errors_count below.
     *
     * Generated from protobuf field <code>.PathErrorStats root_error_stats = 7 [json_name = "rootErrorStats"];</code>
     *
     * @return \Nuwave\Lighthouse\Tracing\FederatedTracing\Proto\PathErrorStats|null
     */
    public function getRootErrorStats()
    {
        return $this->root_error_stats;
    }

    public function hasRootErrorStats()
    {
        return isset($this->root_error_stats);
    }

    public function clearRootErrorStats()
    {
        unset($this->root_error_stats);
    }

    /**
     * Paths and counts for each error. The total number of requests with errors within this object should be the same as
     * requests_with_errors_count below.
     *
     * Generated from protobuf field <code>.PathErrorStats root_error_stats = 7 [json_name = "rootErrorStats"];</code>
     *
     * @param  \Nuwave\Lighthouse\Tracing\FederatedTracing\Proto\PathErrorStats  $var
     *
     * @return $this
     */
    public function setRootErrorStats($var)
    {
        GPBUtil::checkMessage($var, \Nuwave\Lighthouse\Tracing\FederatedTracing\Proto\PathErrorStats::class);
        $this->root_error_stats = $var;

        return $this;
    }

    /**
     * Total number of requests that contained at least one error.
     *
     * Generated from protobuf field <code>uint64 requests_with_errors_count = 8 [json_name = "requestsWithErrorsCount"];</code>
     *
     * @return int|string
     */
    public function getRequestsWithErrorsCount()
    {
        return $this->requests_with_errors_count;
    }

    /**
     * Total number of requests that contained at least one error.
     *
     * Generated from protobuf field <code>uint64 requests_with_errors_count = 8 [json_name = "requestsWithErrorsCount"];</code>
     *
     * @param  int|string  $var
     *
     * @return $this
     */
    public function setRequestsWithErrorsCount($var)
    {
        GPBUtil::checkUint64($var);
        $this->requests_with_errors_count = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>repeated sint64 public_cache_ttl_count = 15 [json_name = "publicCacheTtlCount"];</code>.
     *
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPublicCacheTtlCount()
    {
        return $this->public_cache_ttl_count;
    }

    /**
     * Generated from protobuf field <code>repeated sint64 public_cache_ttl_count = 15 [json_name = "publicCacheTtlCount"];</code>.
     *
     * @param  array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField  $var
     *
     * @return $this
     */
    public function setPublicCacheTtlCount($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::SINT64);
        $this->public_cache_ttl_count = $arr;

        return $this;
    }

    /**
     * Generated from protobuf field <code>repeated sint64 private_cache_ttl_count = 16 [json_name = "privateCacheTtlCount"];</code>.
     *
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPrivateCacheTtlCount()
    {
        return $this->private_cache_ttl_count;
    }

    /**
     * Generated from protobuf field <code>repeated sint64 private_cache_ttl_count = 16 [json_name = "privateCacheTtlCount"];</code>.
     *
     * @param  array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField  $var
     *
     * @return $this
     */
    public function setPrivateCacheTtlCount($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::SINT64);
        $this->private_cache_ttl_count = $arr;

        return $this;
    }

    /**
     * Generated from protobuf field <code>uint64 registered_operation_count = 11 [json_name = "registeredOperationCount"];</code>.
     *
     * @return int|string
     */
    public function getRegisteredOperationCount()
    {
        return $this->registered_operation_count;
    }

    /**
     * Generated from protobuf field <code>uint64 registered_operation_count = 11 [json_name = "registeredOperationCount"];</code>.
     *
     * @param  int|string  $var
     *
     * @return $this
     */
    public function setRegisteredOperationCount($var)
    {
        GPBUtil::checkUint64($var);
        $this->registered_operation_count = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>uint64 forbidden_operation_count = 12 [json_name = "forbiddenOperationCount"];</code>.
     *
     * @return int|string
     */
    public function getForbiddenOperationCount()
    {
        return $this->forbidden_operation_count;
    }

    /**
     * Generated from protobuf field <code>uint64 forbidden_operation_count = 12 [json_name = "forbiddenOperationCount"];</code>.
     *
     * @param  int|string  $var
     *
     * @return $this
     */
    public function setForbiddenOperationCount($var)
    {
        GPBUtil::checkUint64($var);
        $this->forbidden_operation_count = $var;

        return $this;
    }

    /**
     * The number of requests that were executed without field-level
     * instrumentation (and thus do not contribute to `observed_execution_count`
     * fields on this message's cousin-twice-removed FieldStats).
     *
     * Generated from protobuf field <code>uint64 requests_without_field_instrumentation = 17 [json_name = "requestsWithoutFieldInstrumentation"];</code>
     *
     * @return int|string
     */
    public function getRequestsWithoutFieldInstrumentation()
    {
        return $this->requests_without_field_instrumentation;
    }

    /**
     * The number of requests that were executed without field-level
     * instrumentation (and thus do not contribute to `observed_execution_count`
     * fields on this message's cousin-twice-removed FieldStats).
     *
     * Generated from protobuf field <code>uint64 requests_without_field_instrumentation = 17 [json_name = "requestsWithoutFieldInstrumentation"];</code>
     *
     * @param  int|string  $var
     *
     * @return $this
     */
    public function setRequestsWithoutFieldInstrumentation($var)
    {
        GPBUtil::checkUint64($var);
        $this->requests_without_field_instrumentation = $var;

        return $this;
    }
}
