<?php declare(strict_types=1);

namespace Nuwave\Lighthouse\Schema\Directives;

class ScalarDirective extends BaseDirective
{
    public static function definition(): string
    {
        return /** @lang GraphQL */ <<<'GRAPHQL'
"""
Reference a class implementing a scalar definition.
"""
directive @scalar(
  """
  Reference to a class that extends `\GraphQL\Type\Definition\ScalarType`.
  """
  class: String!
) on SCALAR
GRAPHQL;
    }
}
