<?php
use App\Http\Controllers\Api\ProductController;

  Route::get('/products', [ProductController::class, 'index'])->middleware('permission:Listar Productos');
  Route::post('/products', [ProductController::class, 'store'])->middleware('permission:Crear Productos');
  Route::put('/products/{id}', [ProductController::class, 'update'])->middleware('permission:Actualizar Productos');
  Route::delete('/products/{id}', [ProductController::class, 'destroy'])->middleware('permission:Eliminar Productos');

  // Files
  Route::delete('/imageProducts/{file}', [ProductController::class, 'deleteImage'])->middleware('permission:Eliminar Productos');