<?php
use App\Http\Controllers\Api\CategoryController;

  Route::get('/allCategories', [CategoryController::class, 'allCategories'])->middleware('permission:Listar Categorias');
  Route::get('/categories', [CategoryController::class, 'index'])->middleware('permission:Listar Categorias');
  Route::post('/categories', [CategoryController::class, 'store'])->middleware('permission:Crear Categorias');
  Route::put('/categories/{id}', [CategoryController::class, 'update'])->middleware('permission:Actualizar Categorias');
  Route::delete('/categories/{id}', [CategoryController::class, 'destroy'])->middleware('permission:Eliminar Categorias');