<?php
use App\Http\Controllers\Api\AppointmentController;

  Route::get('/appointments', [AppointmentController::class, 'index'])->middleware('permission:Listar Citas');
  Route::post('/appointments', [AppointmentController::class, 'store'])->middleware('permission:Crear Citas');
  Route::put('/appointments/{id}', [AppointmentController::class, 'update'])->middleware('permission:Actualizar Citas');
  Route::delete('/appointments', [AppointmentController::class, 'destroy'])->middleware('permission:Eliminar Citas');

  Route::get('/appointment_available', [AppointmentController::class, 'appointmentAvailable'])->middleware('permission:Listar Citas');
