<?php

use App\Http\Controllers\Api\AuthController;
use Illuminate\Http\Request;

// categories
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
 */

Route::post('/auth/register', [AuthController::class, 'createUser']);
Route::post('/auth/login', [AuthController::class, 'loginUser']);

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

// Files
require __DIR__ . '/../routes/modules/file.php';


Route::middleware('auth:sanctum')->group(function () {

    // Logout
    Route::get('/auth/logout', [AuthController::class, 'logout']);

    // CheckStatus
    Route::get('/auth/check-status', [AuthController::class, 'checkStatus']);
 
    // Categories
    require __DIR__ . '/../routes/modules/params/category.php';

    // Services
    require __DIR__ . '/../routes/modules/params/service.php';

    // Products
    require __DIR__ . '/../routes/modules/params/product.php';

     // TypeProducts
     require __DIR__ . '/../routes/modules/params/TypeProduct.php';

     // TypeSkins
     require __DIR__ . '/../routes/modules/params/TypeSkin.php';

    // Roles
    require __DIR__ . '/../routes/modules/params/role.php';

     // users
     require __DIR__ . '/../routes/modules/params/user.php';

     // hear about us
     require __DIR__ . '/../routes/modules/params/hear_about_us.php';

     // Occupation
     require __DIR__ . '/../routes/modules/params/occupation.php';

    // Appointment
    require __DIR__ . '/../routes/modules/appointment.php';

    // Survey
    require __DIR__ . '/../routes/modules/params/survey.php';
     
    // GeneralHealth
    require __DIR__ . '/../routes/modules/general_health.php';

    // FacialCare
    require __DIR__ . '/../routes/modules/facial_care.php';

    // BustCare
    require __DIR__ . '/../routes/modules/bust_care.php';

     // BodyCare
     require __DIR__ . '/../routes/modules/body_care.php';
});
