<?php

namespace Database\Seeders\questions;

use App\Enums\TypeInput;
use App\Models\Question;
use App\Models\QuestionOption;

class GeneralHealth
{

    public static function generate()
    {
        $survey_id = 1;
        $rows = [
            // Survey #$survey_id
            [ // $survey_id
                'survey_id' => $survey_id,
                'question' => 'Altura', 'type_input' => TypeInput::TEXT,
            ],
            [
                'survey_id' => $survey_id,
                'question' => 'Peso', 'type_input' => TypeInput::TEXT,
            ],

            [
                'survey_id' => $survey_id,
                'question' => 'Salud', 'type_input' => TypeInput::RADIO,
            ],

            [
                'survey_id' => $survey_id,
                'question' => 'Enfermedades (Describir - fecha)', 'type_input' => TypeInput::TEXT,
            ],
            [
                'survey_id' => $survey_id, //5
                'question' => 'Medicamentos (Describir, ahora, en el pasado)', 'type_input' => TypeInput::TEXT,
            ],
            [
                'survey_id' => $survey_id,
                'question' => 'Operaciones (Describir - fecha)', 'type_input' => TypeInput::TEXT,
            ],
            [
                'survey_id' => $survey_id,
                'question' => 'Sueño', 'type_input' => TypeInput::RADIO,
            ],
            [
                'survey_id' => $survey_id,
                'question' => 'Apetito', 'type_input' => TypeInput::TEXT,
            ],
            [
                'survey_id' => $survey_id,
                'question' => 'Habitos alimenticios y estilo de vida', 'type_input' => TypeInput::CHECKBOX,
            ],
            [
                'survey_id' => $survey_id, //$survey_id0
                'question' => 'Sistema digestivo (problemas digestivos,estreñimiento)', 'type_input' => TypeInput::TEXT,
            ],
            [
                'survey_id' => $survey_id,
                'question' => 'Alergia (cuales)', 'type_input' => TypeInput::TEXT,
            ],
            [
                'survey_id' => $survey_id,
                'question' => 'Problemas dentales', 'type_input' => TypeInput::TEXT,
            ],
            [
                'survey_id' => $survey_id,
                'question' => 'Embarazo', 'type_input' => TypeInput::RADIO,
            ],
            [
                'survey_id' => $survey_id,
                'question' => 'Hijos', 'type_input' => TypeInput::TEXT,
            ],
            [ //$survey_id5
                'survey_id' => $survey_id,
                'question' => 'Lactancia Materna', 'type_input' => TypeInput::RADIO,
            ],
            [
                'survey_id' => $survey_id,
                'question' => 'Periodos', 'type_input' => TypeInput::CHECKBOX,
            ],
            [
                'survey_id' => $survey_id,
                'question' => 'Menopausia (si es si - edad)', 'type_input' => TypeInput::RADIO,
            ],
            [
                'survey_id' => $survey_id,
                'question' => 'Vida Sexual', 'type_input' => TypeInput::RADIO,
            ],
            [ // $survey_id9
                'survey_id' => $survey_id,
                'question' => 'Anticonceptivos', 'type_input' => TypeInput::RADIO,
            ],

        ];

        foreach ($rows as $data) {
            $q = Question::create($data);
        }
        self::generate_qo();
    }

    private static function generate_qo(): void
    {
        $options = [
            [['required_answer' => 1, 'qo' => 'str']],
            [['required_answer' => 1, 'qo' => 'str']],
            [['required_answer' => 0, 'qo' => 'Buena'], ['required_answer' => 0, 'qo' => 'Promedio'], ['required_answer' => 0, 'qo' => 'Malo']],
            [['required_answer' => 1, 'qo' => 'str']],
            [['required_answer' => 1, 'qo' => 'str']],
            [['required_answer' => 1, 'qo' => 'str']],
            [['required_answer' => 0, 'qo' => 'Normal'], ['required_answer' => 0, 'qo' => 'Malo']],
            [['required_answer' => 1, 'qo' => 'str']],
            [['required_answer' => 0, 'qo' => 'Tabaco'], ['required_answer' => 0, 'qo' => 'Alcohol'], ['required_answer' => 0, 'qo' => 'Azúcar'], ['required_answer' => 0, 'qo' => 'Sal'], ['required_answer' => 0, 'qo' => 'Bebe (agua)'], ['required_answer' => 0, 'qo' => 'Deporte']],
            [['required_answer' => 0, 'qo' => 'str']],
            [['required_answer' => 0, 'qo' => 'str']],
            [['required_answer' => 0, 'qo' => 'str']],
            [['required_answer' => 0, 'qo' => 'No'], ['required_answer' => 0, 'qo' => 'Si']],
            [['required_answer' => 0, 'qo' => 'No'], ['required_answer' => 0, 'qo' => 'Si']],
            [['required_answer' => 0, 'qo' => 'Si'], ['required_answer' => 0, 'qo' => 'No'], ['required_answer' => 0, 'qo' => 'En curso']],
            [['required_answer' => 0, 'qo' => 'No'], ['required_answer' => 0, 'qo' => 'Irregular'], ['required_answer' => 0, 'qo' => 'Abundante'], ['required_answer' => 0, 'qo' => 'Doloroso']],
            [['required_answer' => 0, 'qo' => 'No'], ['required_answer' => 0, 'qo' => 'Si']],
            [['required_answer' => 0, 'qo' => 'Normal'], ['required_answer' => 0, 'qo' => 'Ocasional']],
            [['required_answer' => 0, 'qo' => 'Pastillas'], ['required_answer' => 0, 'qo' => 'Otros']],
        ];

        $start_id = 1;
        $end_id = 19;

        for ($id = $start_id; $id <= $end_id; $id++) {

            foreach ($options[$id - $start_id] as $opt) {
               
                QuestionOption::create([
                    'question_id' => $id,
                    'question_option' => $opt['qo'],
                    'required_answer' => $opt['required_answer'],
                ]);

            }
        }

    }

}
