<?php

namespace Database\Seeders\questions;

use App\Enums\TypeInput;
use App\Models\Question;
use App\Models\QuestionOption;

class FacialCare
{

    public static function generate()
    {
        $survey_id = 2;
        $rows = [
            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id, // 1
                    'question' => 'Tipo de piel (Describir)', 'type_input' => TypeInput::TEXT,
                ],
            ],

            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id,
                    'question' => 'Cuidado facial habitual', 'type_input' => TypeInput::TEXT,
                ],
            ],

            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id,
                    'question' => ' Cuidados de la piel pasados', 'type_input' => TypeInput::TEXT,
                ],
            ],

            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id,
                    'question' => 'Cirugía plástica, dermabrasión, botox, otros (describir)', 'type_input' => TypeInput::TEXT,
                ],
            ],

            [
                'question_option' => [['required_answer' => 1, 'qo' => '1er Tratamiento'], ['required_answer' => 1, 'qo' => '2do Tratamiento'], ['required_answer' => 1, 'qo' => '3ro Tratamiento'], ['required_answer' => 1, 'qo' => '4to Tratamiento'],
                    ['required_answer' => 1, 'qo' => '5to Tratamiento'], ['required_answer' => 1, 'qo' => '6to Tratamiento'], ['required_answer' => 1, 'qo' => '7mo Tratamiento'], ['required_answer' => 1, 'qo' => '8vo Tratamiento'],
                    ['required_answer' => 1, 'qo' => '9no Tratamiento'], ['required_answer' => 1, 'qo' => '10mo Tratamiento']], // 5
                'question' => [
                    'survey_id' => $survey_id,
                    'question' => 'Tratamiento de Cabina', 'type_input' => TypeInput::TEXT, 'question_category_id' => 3
                ],
            ],

            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id, //5
                    'question' => 'Resultados de cabina', 'type_input' => TypeInput::TEXT,
                ],
            ],

            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id,
                    'question' => 'Productos recomendados para el uso en casa', 'type_input' => TypeInput::TEXT,
                ],
            ],

            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id,
                    'question' => 'Consejos de nutrición', 'type_input' => TypeInput::TEXT,
                ],
            ],

            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id, // 8
                    'question' => 'Comentarios', 'type_input' => TypeInput::TEXT,
                ],
            ],

        ];

        foreach ($rows as $data) {
            $q = Question::create($data['question']);
            self::generate_qo($q->id, $data['question_option']);
        }
    }

    private static function generate_qo($id, $options): void
    {
        foreach ($options as $opt) {

            QuestionOption::create([
                'question_id' => $id,
                'question_option' => $opt['qo'],
                'required_answer' => $opt['required_answer'],
            ]);

        }
        // }

    }

}
