<?php

namespace Database\Seeders\questions;

use App\Enums\TypeInput;
use App\Models\Question;
use App\Models\QuestionOption;

class BodyCare
{

    private static function getOptionsMedicamentos(): array
    {
        return [
            ['required_answer' => 1, 'qo' => 'Cintura'],
            ['required_answer' => 1, 'qo' => 'Cadera'],
            ['required_answer' => 1, 'qo' => 'D Muslo'],
            ['required_answer' => 1, 'qo' => 'I Muslo'],
            ['required_answer' => 1, 'qo' => 'D Rodilla'],
            ['required_answer' => 1, 'qo' => 'I Rodilla'],
            ['required_answer' => 1, 'qo' => 'D Tobillo'],
            ['required_answer' => 1, 'qo' => 'I Tobillo'],
        ];
    }


    public static function generate()
    {
        $survey_id = 4;
        $rows = [
            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id, // 1
                    'question' => 'Tipo de fisiológico (venas visibles, varices, celulitis, estrias, cicatrices, acné, otros).', 'type_input' => TypeInput::TEXT,
                ],
            ],

            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id,
                    'question' => 'Cuidado corporal habitual', 'type_input' => TypeInput::TEXT,
                ],
            ],

            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id,
                    'question' => ' Cuidado corporal pasado', 'type_input' => TypeInput::TEXT,
                ],
            ],

            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id,
                    'question' => 'Cirugías, liposucción, varices, otras (describir)', 'type_input' => TypeInput::TEXT,
                ],
            ],

            // Medicamentos antes del tratamiento
            [
                'question' => ['question' => 'Tratamiento Nro 1', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT, 'question_category_id' => 1],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 2', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 1],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 3', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 1],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 4', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 1],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 5', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 1],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 6', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 1],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 7', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 1],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 8', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 1],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 9', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 1],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 10', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 1],
                'question_option' => self::getOptionsMedicamentos()
            ],



            // Tratamiento de cabina 

            [
                'question_option' => [['required_answer' => 1, 'qo' => '1er Tratamiento'], ['required_answer' => 1, 'qo' => '2do Tratamiento'], ['required_answer' => 1, 'qo' => '3ro Tratamiento'], ['required_answer' => 1, 'qo' => '4to Tratamiento'],
                    ['required_answer' => 1, 'qo' => '5to Tratamiento'], ['required_answer' => 1, 'qo' => '6to Tratamiento'], ['required_answer' => 1, 'qo' => '7mo Tratamiento'], ['required_answer' => 1, 'qo' => '8vo Tratamiento'],
                    ['required_answer' => 1, 'qo' => '9no Tratamiento'], ['required_answer' => 1, 'qo' => '10mo Tratamiento']], // 5
                'question' => [
                    'survey_id' => $survey_id,
                    'question' => 'Tratamiento de Cabina', 'type_input' => TypeInput::TEXT, 'question_category_id' => 3
                ],
            ],

            // Medicamentos despues del tratamiento
            [
                'question' => ['question' => 'Tratamiento Nro 1', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 2],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 2', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 2],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 3', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 2],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 4', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 2],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 5', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 2],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 6', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 2],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 7', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 2],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 8', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 2],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 9', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 2],
                'question_option' => self::getOptionsMedicamentos()
            ],
            [
                'question' => ['question' => 'Tratamiento Nro 10', 'survey_id' => $survey_id, 'type_input' => TypeInput::TEXT,'question_category_id' => 2],
                'question_option' => self::getOptionsMedicamentos()
            ],


            //final

            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id,
                    'question' => 'Productos recomendados para el uso en casa', 'type_input' => TypeInput::TEXT,
                ],
            ],

            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id,
                    'question' => 'Consejos de nutrición', 'type_input' => TypeInput::TEXT,
                ],
            ],

            [
                'question_option' => [['required_answer' => 1, 'qo' => 'str']],
                'question' => [
                    'survey_id' => $survey_id, // 8
                    'question' => 'Comentarios', 'type_input' => TypeInput::TEXT,
                ],
            ],

        ];

        foreach ($rows as $data) {
            $q = Question::create($data['question']);
            self::generate_qo($q->id, $data['question_option']);
        }
    }

    private static function generate_qo($id, $options): void
    {
        foreach ($options as $opt) {

            QuestionOption::create([
                'question_id' => $id,
                'question_option' => $opt['qo'],
                'required_answer' => $opt['required_answer'],
            ]);

        }
        // }

    }

}
