<?php

namespace Database\Seeders;

use App\Models\Service;
use Illuminate\Database\Seeder;

class ServicesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            [
                'category_id' => 1,
                'name' => 'DIAGNOSTICO ',
                'price' => '0',
                'duration' => '00:15',
                'additional_time' => '00:20',
                'observation' => 'CUANDO UNA CLIENTA ES NUEVA SE DEBE CONSIDERAR 20 MINUTOS PREVIO PARA LLENAR FICHA Y EVALUACIÓN',
            ],

            [
                'category_id' => 1,
                'name' => 'MADEROTERAPIA',
                'price' => '30',
                'duration' => '00:30',
            ],

            [
                'category_id' => 1,
                'name' => 'APARATOLOGIA',
                'price' => '35',
                'duration' => '00:30',
            ],

            [
                'category_id' => 1,
                'name' => 'BODY DESIGNER',
                'price' => '60',
                'duration' => '00:30',
            ],

            [
                'category_id' => 1,
                'name' => 'ELECTRODOS',
                'price' => '35',
                'duration' => '00:30',
            ],

            [
                'category_id' => 1,
                'name' => 'CRIOLIPOLISIS',
                'price' => '100',
                'duration' => '01:00',
            ],

            [
                'category_id' => 1,
                'name' => 'X-WAZE',
                'price' => '80',
                'duration' => '00:30',
            ],

            [
                'category_id' => 1,
                'name' => 'MASAJES DRENANTES',
                'price' => '60',
                'duration' => '00:30',
            ],

            [
                'category_id' => 1,
                'name' => 'MASAJES RELAJANTE LOCALIZADO',
                'price' => '30',
                'duration' => '00:30',
                'additional_time' => '00:10',
                'observation' => 'HIGIENIZACION DE CABINA DE UNA CLIENTA A OTRA 10 MINUTOS',
            ],

            [
                'category_id' => 1,
                'name' => 'MASAJE RELAJANTE COMPLETO',
                'price' => '60',
                'duration' => '01:00',
                'additional_time' => '00:10',
                'observation' => 'HIGIENIZACION DE CABINA DE UNA CLIENTA A OTRA 10 MINUTOS',
            ],

            [
                'category_id' => 1,
                'name' => 'MASAJE DE PIEDRAS CALIENTES COMPLETO',
                'price' => '60',
                'duration' => '01:00',
            ],

            [
                'category_id' => 1,
                'name' => 'MASAJE DE PIEDRAS CALIENTES',
                'price' => '30',
                'duration' => '00:30',
            ],

            [
                'category_id' => 1,
                'name' => 'MASAJE DE VELAS',
                'price' => '30',
                'duration' => '00:35',
            ],

            [
                'category_id' => 1,
                'name' => 'MASAJE DE VELAS COMPLETO',
                'price' => '70',
                'duration' => '00:35',
            ],

            [
                'category_id' => 1,
                'name' => 'MASAJE DE PIERNAS PERFECTAS (GERNETIC)',
                'price' => '50',
                'duration' => '00:30',
            ],

            [
                'category_id' => 1,
                'name' => 'LEVANTAMIENTO DE GLUTEOS CON MADEROTERAPIA',
                'price' => '30',
                'duration' => '00:30',
            ],

            [
                'category_id' => 1,
                'name' => 'MADERA + MASCARILLA REDUCTORA',
                'price' => '75',
                'duration' => '01:00',
            ],

            [
                'category_id' => 1,
                'name' => 'MASCARILLA REDUCTORA',
                'price' => '45',
                'duration' => '00:45',
            ],

            [
                'category_id' => 1,
                'name' => 'RADIOFRECUENCIA FRACCIONADA',
                'price' => '125',
                'duration' => '01:20',
            ],

            [
                'category_id' => 1,
                'name' => 'MESOTERAPIA CORPORAL',
                'price' => '60',
                'duration' => '00:45',
            ],

            [
                'category_id' => 1,
                'name' => 'PAQUETES REDUCTORES',
                'price' => '300',
                'duration' => '01:00',
            ],

            [
                'category_id' => 2,
                'name' => 'LIMPIEZA FACIAL PROFUNDA',
                'price' => '70',
                'duration' => '01:20',
                'additional_time' => '00:10',
                'observation' => 'HIGIENIZACION DE CABINA DE UNA CLIENTA A OTRA 10 MINUTOS',
            ],

            [
                'category_id' => 2,
                'name' => 'LIMPIEZA FACIAL EXPRESS',
                'price' => '30',
                'duration' => '00:30',
                'additional_time' => '00:10',
                'observation' => 'HIGIENIZACION DE CABINA DE UNA CLIENTA A OTRA 10 MINUTOS',
            ],

            [
                'category_id' => 2,
                'name' => 'MASAJE DE MADEROTERAPIA FACIAL',
                'price' => '45',
                'duration' => '00:45',
            ],

            [
                'category_id' => 2,
                'name' => 'TRATAMIENTO DE OJERAS Y BOLSAS (GERNETIC)',
                'price' => '65',
                'duration' => '01:00',
            ],

            [
                'category_id' => 2,
                'name' => 'HIDRATACION PROFUNDA FACIAL (GERNETIC)',
                'price' => '60',
                'duration' => '00:45',
            ],

            [
                'category_id' => 2,
                'name' => 'HIDRATACION PROFUNDA FACIAL',
                'price' => '50',
                'duration' => '00:35',
            ],

            [
                'category_id' => 2,
                'name' => 'LIMPIEZA FACIAL TEENS',
                'price' => '45',
                'duration' => '00:45',
            ],

            [
                'category_id' => 2,
                'name' => 'LIMPIEZA FACIAL MEN',
                'price' => '40',
                'duration' => '00:30',
            ],

            [
                'category_id' => 2,
                'name' => 'DERMAPLANING',
                'price' => '30',
                'duration' => '00:30',
            ],

            [
                'category_id' => 2,
                'name' => 'DERMAPEN',
                'price' => '80',
                'duration' => '01:00',
            ],

            [
                'category_id' => 2,
                'name' => 'TRATAMIENTO DE ACNE',
                'price' => '55',
                'duration' => '01:00',
            ],

            [
                'category_id' => 2,
                'name' => 'MESOTERAPIA FACIAL',
                'price' => '60',
                'duration' => '00:45',
            ],

            [
                'category_id' => 2,
                'name' => 'MICRODERMOABRASIÓN',
                'price' => '35',
                'duration' => '00:45',
            ],

            [
                'category_id' => 2,
                'name' => 'MASCARA LED',
                'price' => '35',
                'duration' => '00:30',
            ],

            [
                'category_id' => 2,
                'name' => 'RADIOFRECUENCIA FACIAL',
                'price' => '35',
                'duration' => '00:30',
            ],

            [
                'category_id' => 3,
                'name' => 'HIDRATACIÓN CAPILAR PROFUNDA WELLNESS',
                'price' => '50',
                'duration' => '01:00',
                'observation' => 'SE LE DEBE ADICIONAR COMO NOTA QUE EL VOLUMEN Y LARGO SE COBRA UN ADICIONAL ',
            ],

            [
                'category_id' => 3,
                'name' => 'HIDRATACIÓN CAPILAR DE RIZOS WELLNESS',
                'price' => '60',
                'duration' => '01:00',
                'observation' => 'SE LE DEBE ADICIONAR COMO NOTA QUE EL VOLUMEN Y LARGO SE COBRA UN ADICIONAL ',
            ],

            [
                'category_id' => 3,
                'name' => 'BOTOX CAPILAR',
                'price' => '120',
                'duration' => '02:00',
            ],

            [
                'category_id' => 3,
                'name' => 'EXFOLIACIÓN CAPILAR',
                'price' => '55',
                'duration' => '01:20',
            ],

            [
                'category_id' => 3,
                'name' => 'TRATAMIENTO CONTROLADOR DE PH',
                'price' => '55',
                'duration' => '01:00',
            ],

            [
                'category_id' => 3,
                'name' => 'TRATAMIENTO DE BAÑO DE BARNIZ',
                'price' => '55',
                'duration' => '01:00',
                'additional_time' => '00:10',
                'observation' => 'HIGIENIZACION DE CABINA DE UNA CLIENTA A OTRA 10 MINUTOS',
            ],

            [
                'category_id' => 3,
                'name' => 'CUBRIMIENTO DE CANAS',
                'price' => '50',
                'duration' => '01:45',
                'additional_time' => '00:10',
                'observation' => 'HIGIENIZACION DE CABINA DE UNA CLIENTA A OTRA 10 MINUTOS',
            ],

            [
                'category_id' => 3,
                'name' => 'TINTURADO BASE',
                'price' => '65',
                'duration' => '01:45',
            ],

            [
                'category_id' => 3,
                'name' => 'SHAIN DE COLOR',
                'price' => '60',
                'duration' => '01:00',
            ],

            [
                'category_id' => 3,
                'name' => 'CUBRIMIENTO DE CANAS 10 MIN ASCET',
                'price' => '55',
                'duration' => '01:20',
            ],

            [
                'category_id' => 3,
                'name' => 'TINTURADO BASE 10 MIN ASCET',
                'price' => '60',
                'duration' => '01:20',
            ],

            [
                'category_id' => 3,
                'name' => 'CORTE DE PUNTAS',
                'price' => '20',
                'duration' => '00:30',
            ],

            [
                'category_id' => 3,
                'name' => 'CORTE CON ESTILO',
                'price' => '30',
                'duration' => '01:00',
            ],

            [
                'category_id' => 3,
                'name' => 'CEPILLADO',
                'price' => '15',
                'duration' => '00:45',
            ],

            [
                'category_id' => 3,
                'name' => 'PLANCHADO',
                'price' => '15',
                'duration' => '00:45',
            ],

            [
                'category_id' => 3,
                'name' => 'CEPILLADO + PLANCHADO',
                'price' => '25',
                'duration' => '01:30',
            ],

            [
                'category_id' => 3,
                'name' => 'TRATAMIENTO EFECTO ESPEJO',
                'price' => '55',
                'duration' => '01:00',
            ],
        ];

        foreach ($services as $service) {
            $s = Service::create($service);
            // $surveyId = $this->getSurveyId($s->category_id);
            // if(!is_null($surveyId))
            //     $s->surveys()->sync([$surveyId]);
        }

    }

    private function getSurveyId($id){
        switch($id){
            case 1:
                return 4;
                break;
            
            case 2:
                return 2;
                break;
            
            
            default:
            return null;

    }
    }

}
