<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $adminRole = Role::create(['name' => 'admin']);
        $estheticianRole = Role::create(['name' => 'estetisista']); // esthetician
        $clientRole = Role::create(['name' => 'cliente']);

        $adminRole->syncPermissions(Permission::all());

        $permissionsClients = [];

        // citas
        $permissionsClients = array_merge($permissionsClients, [
            'Listar Citas',
            'Crear Citas',
            'Ver Citas'
        ]);

         // Servicios
         $permissionsClients = array_merge($permissionsClients, [
            'Listar Servicios',
            'Ver Servicios',
            'Eliminar Servicios'
        ]);

          // Categorias
          $permissionsClients = array_merge($permissionsClients, [
            'Listar Categorias',
        ]);


        $clientRole->syncPermissions(Permission::whereIn('name', $permissionsClients )->get());

    }
}