<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\QuestionOption;

class QuestionOptionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $rows = [
            ['question_id' => 1, 'question_option' => 'str'],
            ['question_id' => 2, 'question_option' => 'str'],
            ['question_id' => 3, 'question_option' => 'Buena'],
            ['question_id' => 3, 'question_option' => 'Promedio'],
            ['question_id' => 3, 'question_option' => 'Malo'],
            ['question_id' => 4, 'question_option' => 'str'],
            ['question_id' => 5, 'question_option' => 'str'],
            ['question_id' => 6, 'question_option' => 'str'],
            ['question_id' => 7, 'question_option' => 'Normal'],
            ['question_id' => 7, 'question_option' => 'Malo'],
            ['question_id' => 8, 'question_option' => 'str'],
            ['question_id' => 9, 'question_option' => 'Tabaco'],
            ['question_id' => 9, 'question_option' => 'Alcohol'],
            ['question_id' => 9, 'question_option' => 'Azúcar'],
            ['question_id' => 9, 'question_option' => 'Sal'],
            ['question_id' => 9, 'question_option' => 'Bebe (agua)'],
            ['question_id' => 9, 'question_option' => 'Deporte'],
            ['question_id' => 10, 'question_option' => 'str'],
            ['question_id' => 11, 'question_option' => 'str'],
            ['question_id' => 12, 'question_option' => 'str'],
            ['question_id' => 13, 'question_option' => 'No'],
            ['question_id' => 13, 'question_option' => 'Si'],
            ['question_id' => 14, 'question_option' => 'No'],
            ['question_id' => 14, 'question_option' => 'Si'],
            ['question_id' => 15, 'question_option' => 'Si'],
            ['question_id' => 15, 'question_option' => 'No'],
            ['question_id' => 15, 'question_option' => 'En curso'],
            ['question_id' => 16, 'question_option' => 'No'],
            ['question_id' => 16, 'question_option' => 'Irregular'],
            ['question_id' => 16, 'question_option' => 'Abundante'],
            ['question_id' => 16, 'question_option' => 'Doloroso'],
            ['question_id' => 17, 'question_option' => 'No'],
            ['question_id' => 17, 'question_option' => 'Si'],
            ['question_id' => 18, 'question_option' => 'Normal'],
            ['question_id' => 18, 'question_option' => 'Ocasional'],
            ['question_id' => 19, 'question_option' => 'Pastillas'],
            ['question_id' => 19, 'question_option' => 'Otros'],
        ];

        foreach($rows as $data){
            $this->create($data);
        }
        
    }

    private function create($data = [])
    {
        QuestionOption::create($data);
    }
}
