<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('appointments', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('employee_id')->nullable();
            $table->unsignedBigInteger('client_id');
            $table->unsignedBigInteger('service_id');
            $table->unsignedBigInteger('deleted_by')->nullable();

            $table->datetime('start_time');
            $table->datetime('finish_time');
            $table->enum('status', ['pending', 'processing', 'processed'])->default('pending');
            $table->string('comments')->nullable();

            $table->timestamps();
            $table->softDeletes(); 

            $table->foreign('employee_id')->references('id')->on('users')->onDelete('RESTRICT')->onDelete('RESTRICT');
            $table->foreign('client_id')->references('id')->on('users')->onDelete('RESTRICT')->onDelete('RESTRICT');
            $table->foreign('deleted_by')->references('id')->on('users')->onDelete('RESTRICT')->onDelete('RESTRICT');
            $table->foreign('service_id')->references('id')->on('services')->onDelete('RESTRICT')->onDelete('RESTRICT');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('appointments');
    }
};
