<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('category_id');

            $table->string('name');
            $table->text('observation')->nullable();
            $table->double('price')->default('0.0');
            $table->time('duration')->default('00:00:00');
            $table->time('additional_time')->default('00:00:00');

            $table->boolean('active')->default(true);
            $table->timestamps();
            $table->softDeletes(); 

            $table->foreign('category_id')->references('id')->on('categories')->onDelete('RESTRICT')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
