<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('answers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('question_id');
            $table->unsignedBigInteger('question_option_id');
            $table->unsignedBigInteger('evaluation_survey_id');
            $table->text('answer')->nullable();
            $table->timestamps();

            $table->foreign('evaluation_survey_id')->references('id')->on('evaluation_surveys')->onUpdate('RESTRICT')->onDelete('RESTRICT');
            $table->foreign('question_option_id')->references('id')->on('question_options')->onUpdate('RESTRICT')->onDelete('RESTRICT');
            $table->foreign('question_id')->references('id')->on('questions')->onUpdate('RESTRICT')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('answers');
    }
};
