<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('evaluation_surveys', function (Blueprint $table) {
            $table->id();
         
            $table->unsignedBigInteger('general_health_id')->nullable();
            $table->unsignedBigInteger('evaluation_id');
            $table->unsignedBigInteger('survey_id');
            $table->unsignedBigInteger('completed_by')->nullable();
            $table->enum('status', ['pending', 'processing', 'processed'])->default('pending');
            $table->timestamps();

            $table->foreign('general_health_id')->references('id')->on('evaluation_surveys')->onUpdate('RESTRICT')->onDelete('RESTRICT');
            $table->foreign('evaluation_id')->references('id')->on('evaluations')->onUpdate('RESTRICT')->onDelete('RESTRICT');
            $table->foreign('survey_id')->references('id')->on('surveys')->onUpdate('RESTRICT')->onDelete('RESTRICT');
            $table->foreign('completed_by')->references('id')->on('users')->onUpdate('RESTRICT')->onDelete('RESTRICT');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('evaluation_surveys');
    }
};
