<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('questions', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('survey_id');
            $table->unsignedBigInteger('question_category_id')->nullable();

            $table->text('question');
            $table->enum('type_input', ['text', 'textarea', 'radio', 'checkbox', 'select','date', 'time', 'datetime']);
            $table->integer('order')->nullable();
            $table->boolean('active')->default(1);

            $table->timestamps();
            $table->softDeletes();

            $table->foreign('survey_id')->references('id')->on('surveys')->onDelete('CASCADE')->onDelete('CASCADE');
            $table->foreign('question_category_id')->references('id')->on('question_categories')->onDelete('CASCADE')->onDelete('CASCADE');


        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('questions');
    }
};
