<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products_skins', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('type_skin_id');
            $table->unsignedBigInteger('product_id');

            
            $table->timestamps();
            $table->softDeletes(); 

            $table->foreign('type_skin_id')->references('id')->on('type_skins')->onDelete('RESTRICT')->onDelete('RESTRICT');
            $table->foreign('product_id')->references('id')->on('products')->onDelete('RESTRICT')->onDelete('RESTRICT');


        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products_skins');
    }
};
