<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('type_product_id');

            $table->string('name');
            $table->text('description')->nullable();
            $table->boolean('active')->default(true);

            $table->timestamps();
            $table->softDeletes(); 

            $table->foreign('type_product_id')->references('id')->on('type_products')->onDelete('RESTRICT')->onDelete('RESTRICT');


        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
