<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('occupation_id')->nullable();
            $table->unsignedBigInteger('hear_about_us_id')->nullable();

            $table->string('name'); //R
            $table->string('lastname'); //R
            $table->date('date_birth')->nullable(); 
            $table->string('username')->nullable();
            $table->string('mobile')->nullable();
            $table->string('telephone')->nullable();
            $table->string('identification')->unique();  //R
            $table->enum('gender', ['F', 'M', 'B'])->nullable();
            $table->string('email')->unique(); //R
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->string('profile_photo_path', 2048)->nullable();
            $table->boolean('active')->default(1);

            $table->timestamps();
            $table->softDeletes(); 

            $table->foreign('occupation_id')->references('id')->on('occupations')->onDelete('RESTRICT')->onDelete('RESTRICT');
            $table->foreign('hear_about_us_id')->references('id')->on('hear_about_us')->onDelete('RESTRICT')->onDelete('RESTRICT');


        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
