<?php

namespace App\Rules;

use App\Enums\Status;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\DB;

class NotExistPendingGeneralHealth implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $evaluationPending = DB::table('evaluation_surveys AS es')
            ->leftJoin('evaluations AS e', 'e.id', 'es.evaluation_id')
            ->leftJoin('surveys AS s', 's.id', 'es.survey_id')
            ->where('e.table_name', 'users')
            ->where('e.table_id', $value)
            ->where('e.status', Status::PENDING)
            ->where('s.name', 'Salud en general')
            ->get();

        if (count($evaluationPending)) {
            $fail('General Health Pending');
        }

    }
}
