<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\Auth;
use App\Models\Appointment;

class DeleteAppointment implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $appointment  = Appointment::find($value);    
            
        if(is_null($appointment))
            $fail("Appointment not found");
        
        if(Auth::user()->hasRole('cliente')){
            
            if(Auth::id() != $appointment->client_id)
                $fail("No es tu cita asignada.");
            
        }
        
    }
}
// estetisista