<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\DB;

class CorrectQuestionOptionForQuestion implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */

    private $data;

    public function __construct($data)
    {
        $this->data = $data;

    }

    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (is_array($value)) {
            foreach ($value as $val) {

                if(is_null($val))
                    continue;

                    $index = explode('.', $attribute)[1];
                $optionquestion = DB::table('question_options')->where('id', is_array($val) ? key($val) : $val)->where('active', true)->where('question_id', $this->data[$index]['question_id'])->get();

                if (count($optionquestion) == 0) {
                    $fail("Question Option no exist or doesn't belong to the Question 1");
                }

            }

        } else {
            $index = explode('.', $attribute)[1];
            $optionquestion = DB::table('question_options')->where('id', $value)->where('active', true)->where('question_id', $this->data[$index]['question_id'])->get();

            if (count($optionquestion) == 0) {
                $fail("Question Option no exist or doesn't belong to the Question 2");
            }
        }

    }
}
