<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\DB;

class CorrectQuestionForSurvey implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */

     private $data;

     public function __construct($data)
    {
        $this->data = $data;

    }
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $question = DB::table('questions')->where('id', $value)->where('active', true)->where('survey_id', $this->data)->get();
           
        if(count($question) == 0) {
            $fail("Question doesn't belong to the Survey");
        }
    }
}
