<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\DB;

class CorrectEvaluationSurvey implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */

     private $data;

     public function __construct($data)
    {
        $this->data = $data;

    }
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $evaluationSurveyDB = DB::table('evaluation_surveys AS es')
        ->join('surveys AS s', 's.id', '=', 'es.survey_id')
        ->join('evaluations AS e', 'e.id', '=', 'es.evaluation_id')
        ->where('e.table_name', '=', 'users')
        // ->where('e.table_id', '=', $details['user_id'])
        ->where('es.status', '=', Status::PENDING)
        ->where('s.name', '=', 'Salud en general')
        ->where('s.id', $details['survey_id'])
        ->where('e.id', $details['evaluation_id'])
        ->select(['es.*',])
        ->first();

    if (is_null($evaluationSurveyDB)) {
        $fail('General Health not found.');
    }
        
    }
}
