<?php

namespace App\Repositories\TypeSkin;

use App\Models\TypeSkin;

class TypeSkinRepositoryImpl implements TypeSkinRepository
{
    public function getAll() 
    {
        return TypeSkin::all();
    }

    public function paginate($limit = null, $columns = ['*'])
    {
        return TypeSkin::paginate($limit, $columns);
    }
    

    public function getById($id) 
    {
        return TypeSkin::findOrFail($id);
    }

    public function delete($id) : string
    {
        $deleted = TypeSkin::find($id);

        if(is_null($deleted))
            throw new \Exception('Type of Skin not found.');

        $deleted->update(['active'=>false]);
        $deleted->delete();

        return  'successfully deleted';

    }

    public function create(array $data) 
    {
        return TypeSkin::create($data);
    }

    public function update($id, array $data) : string
    {
        $updated = TypeSkin::whereId($id)->update($data);

        if($updated == 0)
            throw new \Exception('Type of Skin not found.');

        return  'successfully updated';
    }

}
