<?php

namespace App\Repositories\TypeProduct;

use App\Models\TypeProduct;

class TypeProductRepositoryImpl implements TypeProductRepository
{
    public function getAll() 
    {
        return TypeProduct::all();
    }

    public function paginate($limit = null, $columns = ['*'])
    {
        return TypeProduct::paginate($limit, $columns);
    }
    

    public function getById($id) 
    {
        return TypeProduct::findOrFail($id);
    }

    public function delete($id) : string
    {
        $deleted = TypeProduct::find($id);

        if(is_null($deleted))
            throw new \Exception('Type of Product not found.');

        $deleted->update(['active'=>false]);
        $deleted->delete();

        return  'successfully deleted';

    }

    public function create(array $data) 
    {
        return TypeProduct::create($data);
    }

    public function update($id, array $data) : string
    {
        $updated = TypeProduct::whereId($id)->update($data);

        if($updated == 0)
            throw new \Exception('Type of Product not found.');

        return  'successfully updated';
    }

}
