<?php

namespace App\Repositories\Shared\Infrastructure\Services\User;

use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class UserRepositoryImpl implements UserRepository
{

    // public function getAll()
    // {
    //     return User::select(['id', 'name'])->get();
    // }

    public function paginate($limit = null, $columns = ['*'])
    {
        return User::with('roles', 'occupation','hearaboutus')->paginate($limit, $columns);
    }


    public function create(array $details)
    {
        try {

            $details['password'] = Hash::make(Str::random(8));
            $user = User::create($details);
            $user->roles()->sync($details['role_id']);
            $user->roles;
            $user->Occupation;
            $user->hearaboutus;

            return $user;

        } catch (\Exception $e) {
            throw new \Exception($e->getMessage());

        }
    }


    public function update($id, array $data): object
    {
        $roleId = $data['role_id'];

        $user = User::find($id);

        if (is_null($user)) {
            throw new \Exception('user not found.');
        }

        $updated = $user->update($data);
        $user->roles()->sync($roleId);

        if ($updated == 0) {
            throw new \Exception('User not found.');
        }

        $user->roles;
        $user->Occupation;
        $user->hearaboutus;

        return $user;
    }

    public function delete($id): string
    {
        $user = User::find($id);

        if (is_null($user)) {
            throw new \Exception('User not found.');
        }

        $user->update(['active' => false]);

        $user->delete();

        return 'successfully deleted';

    }


}
