<?php

namespace App\Repositories\Shared\Infrastructure\Services\Pdf;

use App\Models\EvaluationSurvey;
use App\Models\File;
use PDF;
use App\Repositories\Shared\Infrastructure\Services\File\FileRepositoryImpl;
use App\Repositories\Shared\Infrastructure\Services\Storage\StorageRepositoryImpl;
use Illuminate\Support\Str;

class PdfRepositoryImpl implements PdfRepository
{

    public static function getPdfEvaluationSurvey(File $file)
    {
        try {
            if (!strcmp($file->table_name, 'evaluation_surveys')) {
                $storageRepository = new StorageRepositoryImpl();
                $pdf = $storageRepository->getFileByFullName($file->path, $file->namefile);
                
                if(is_null($pdf))
                    return abort(404);
                
                return response($pdf, 200)->header('Content-Type', 'application/pdf');

            }

            return abort(404);

        } catch (\Exception $e) {
            throw new \Exception($e->getMessage());

        }

    }
    
    public static function generateEvaluationSurveyPdf(EvaluationSurvey $evaluation_survey)
    {
        try {
            $data = $evaluation_survey->toArray();
    
            $pdf = PDF::loadView('pdfs.evaluation_survey.evaluation_survey', $data);
            $pdf->setPaper('A4','portrait');
     
            $storageRepository = new StorageRepositoryImpl();
            $path = 'evaluation_surveys/' . Str::slug($evaluation_survey->survey->name) . '/';
            $namefile = Str::random(30) . '.pdf';
            $fullname = $path . $namefile;
            $data_pdf = $pdf->output(); //return $pdf->stream();
            $storageRepository->put($data_pdf, $fullname, false);
        
            File::create([
                'name'       => $namefile,
                'namefile'   => $namefile,
                'path'       => $path,
                'table_name' => 'evaluation_surveys',
                'table_id'   => $evaluation_survey->id,
                'filetype'   => 'application/pdf',
                'checksum'   => hash('sha1', $data_pdf)
            ]);
            
            return 'listo';

        } catch (\Exception $e) {
            throw $e;
        }
    }

}

