<?php

namespace App\Repositories\Shared\Infrastructure\Services\File;

use App\Models\File;
use Illuminate\Support\Str;

class  FileRepositoryImpl implements FileRepository
{

    public function create($file, $path, $tableId, $tableName) 
    {
        // File
        $filename = preg_replace('/\s/', '-', $file->getClientOriginalName()); // se agrega (_) en donde haya espacio en blanco
        $filename = explode("." . $file->getClientOriginalExtension(), $filename);      // Separamos donde encuentre un . en el nombre original
        $timestamp = (int) round(now()->format('Uu') / pow(10, 6 - 3));
        $filename = $filename[0] . '-' . $timestamp; //. '.' . $file->getClientOriginalExtension(); // le concatenamos la fecha actual y la extension
        $filename = Str::slug($filename);
        $filename = $filename . '.' . $file->getClientOriginalExtension(); // le concatenamos la fecha actual y la extension;

        $type = $file->getMimeType();
        
        return File::create([
            'name'       => $file->getClientOriginalName(),
            'namefile'   => $filename,
            'path'       => $path,
            'table_name' => $tableName,
            'table_id'   => $tableId,
            'filetype'   => $type,
            'checksum'   => hash_file('sha1', $file->getRealPath())

        ]);

    }

    public function deleteAll($tableId, $tableName)
    {
        File::where('table_id', $tableId)
            ->where('table_name', $tableName)
            ->delete();
    }

    public function delete($id)
    {
        $file = File::where('id', $id);

        if(is_null($file))
            throw new \Exception('File not found.');

        $file->delete();

        return  'successfully deleted';

    }

    public function getAllByModel($tableId, $tableName)
    {
        return File::where('table_name', $tableName)
            ->where('table_id', $tableId)
            ->get();
    }

}
