<?php

namespace App\Repositories\Service;

use App\Models\Service;

class ServiceRepositoryImpl implements ServiceRepository
{
    public function getAll() 
    {
        return Service::all();
    }

    public function paginate($filter = [], $limit = null, $columns = ['*'])
    {
        // $services = Service::get();
        if(isset($filter['category_id'])) {
            return Service::where('category_id', $filter['category_id'])->paginate($limit, $columns);

        }
        
        if(isset($filter['search'])) {
            return Service::where('name', 'LIKE', "%" . $filter['search'] . "%")->paginate($limit, $columns);

        }

        return Service::paginate($limit, $columns);
    }
    

    public function getById($id) 
    {
        return Service::findOrFail($id);
    }

    public function delete($id) : string
    {
        $deleted = Service::find($id);

        if(is_null($deleted))
            throw new \Exception('Service not found.');

        $deleted->update(['active'=>false]);
        $deleted->delete();

        return  'successfully deleted';

    }

    public function create(array $data) 
    {
        return Service::create($data);
    }

    public function update($id, array $data) : string
    {
        $updated = Service::whereId($id)->update($data);

        if($updated == 0)
            throw new \Exception('Service not found.');

        return  'successfully updated';
    }

}
