<?php

namespace App\Repositories\EvaluationSurvey;

use App\Enums\Status;
use App\Enums\SurveyName;
use App\Models\Answer;
use Illuminate\Support\Facades\DB;
use App\Models\EvaluationSurvey;
use App\Models\Evaluation;
use App\Models\Survey;
use App\Models\Question;
use App\Models\User;
// use App\Repositories\Shared\Infrastructure\Services\Pdf\PdfRepository;
use App\Repositories\Shared\Infrastructure\Services\Pdf\PdfRepositoryImpl;
use Illuminate\Support\Facades\Auth;

class EvaluationSurveyRepositoryImpl implements EvaluationSurveyRepository

{
    public $survey;
    public $required_questions;
    
    public function paginate($limit = null, $filter = null, $columns = ['*'])
    {
        $evaluationSurvey = EvaluationSurvey::with('survey', 'evaluation', 'files')->whereHas('survey', function ($query) {
            $query->where('name', $this->survey);
        })
        ->orderBy('created_at', 'DESC');

        if(isset($filter['user_id']) && $filter['user_id'])
        $evaluationSurvey->whereHas('evaluation', function ($query) use ($filter) {
            $query->where('table_id', $filter['user_id']);
        });

        return $evaluationSurvey->paginate($limit, $columns);
    }

    public function generate(array $details)
    {

        DB::beginTransaction();
        try {

        $evaluation = new Evaluation();
        $evaluation->table_id = $details['user_id'];
        $evaluation->table_name = 'users';
        $evaluation->status = Status::PENDING;
        $evaluation->save();

        $survey= Survey::where('name', $this->survey)->first();

        $evaluation_survey = new EvaluationSurvey();
        $evaluation_survey->evaluation_id = $evaluation->id;
        $evaluation_survey->survey_id = $survey->id;
        $evaluation_survey->status = Status::PENDING;
        $evaluation_survey->save();

        DB::commit();

        return $this->survey->name . ' created successfully.';

    } catch (\Exception $e) {
        DB::rollback();
        throw $e;
    }
    }


    public function store(array $details)
    {
        DB::beginTransaction();
        try {
            if(isset($details['answers']) && count($details['answers']))
            foreach ($details['answers'] as $answer) {
                if(is_null($answer) || is_null($answer['question_option_id']) || is_null($answer['question_id']))
                    continue;
                
                if(is_array($answer['question_option_id'])){
                    foreach($answer['question_option_id'] as $k => $val) {
                        $ans = is_array($val) ? $val[key($val)] : null;
                        if(is_null($ans)){
                            $ans = isset($answer['answer']) ? $answer['answer'] : null;
                        }


                        $id = -1000;
                        if(isset($val['id'])){
                            $id = $val['id'];

                        } else if(isset($answer['id'])) {
                            $id = $answer['id'];
                        }

                        if(is_null($val))
                            continue;

                        $a = Answer::updateOrCreate(
                            ['id' => $id],
                            [
                                'evaluation_survey_id' => $details['evaluation_survey_id'],
                                'question_id' => $answer['question_id'],
                                'question_option_id' => is_array($val) ? key($val) : $val,
                                'answer' => $ans
                            ]);
                    }

                } else { 

                    $a = Answer::updateOrCreate(
                        ['id' => isset($answer['id']) ? $answer['id'] : -1000],
                        [
                            'evaluation_survey_id' => $details['evaluation_survey_id'],
                            'question_id' => $answer['question_id'],
                            'question_option_id' => $answer['question_option_id'],
                            'answer' => isset($answer['answer']) ? $answer['answer'] : null,
                        ]);
                }

                
                    
            }

            DB::commit();

            
            if(isset($details['finish']) && $details['finish']){
                DB::beginTransaction();

                $required_questions = Question::whereIn('id', $this->required_questions)->get();

                $answers = Answer::where('evaluation_survey_id', $details['evaluation_survey_id'])
                ->whereIn('question_id', $this->required_questions)
                ->get();

                $questions_to_string = $required_questions->whereNotIn('id', array_unique(array_map(fn($element) => $element['question_id'], $answers->toArray())));
                                                
                if(count($questions_to_string)){
                    
                    $msg = "No puede finalizar; no ha constestado correctamente las siguientes preguntas:\n";
                    
                    foreach($questions_to_string as $question) {
                        $msg .= $question->question ."\n";
                    }

                    throw new \Exception($msg);
                }
                
                $evaluation_survey = EvaluationSurvey::find($details['evaluation_survey_id']);
                if(is_null($evaluation_survey))
                    throw new \Exception('Evaluation Survey No found');
    
                $evaluation = $evaluation_survey->evaluation;
                $evaluation->update(['status' => Status::PROCESSED]);

                //
                $user = User::with('Occupation', 'HearAboutUs')->find($evaluation_survey->evaluation->table_id);
                $clientId = $user->id;
                
                $general_health = EvaluationSurvey::with(['survey.questions.questionOptions','survey.questions.questionCategory','answers', 'evaluation', 'completed_by'])
                    ->where('status', Status::PROCESSED)
                    ->where('survey_id', 1)
                    ->whereHas('evaluation', function ($query) use ($clientId){
                        $query->where('table_name', 'users');
                        $query->where('table_id', $clientId);
                    })
                ->latest()->first()->toArray();

                $evaluation_survey->update(['status' => Status::PROCESSED, 'completed_by' => Auth::id(), 'general_health_id' => $general_health['id']]);

                DB::commit();

                //generatePdf
                $this->generatePdf($evaluation_survey->id, $user, $general_health);
            }

            return 'Survey finished successfully.';

        } catch (\Exception $e) {
            DB::rollback();
            throw $e;
        }
    }

    
    public function generatePdf($evaluation_survey_id, $user, $general_health)
    {
        $evaluation_survey = EvaluationSurvey::with(['survey.questions.questionOptions','survey.questions.questionCategory','answers', 'evaluation', 'completed_by'])
        ->where('id', $evaluation_survey_id)->first();
        
        $evaluation_survey['client'] = $user->toArray();
        $evaluation_survey['general_health'] = $general_health;

        $result = PdfRepositoryImpl::generateEvaluationSurveyPdf($evaluation_survey);    
    }

    public function getById($id)
    {   
        $evaluationSurvey = EvaluationSurvey::with(['survey.questions.questionOptions','survey.questions.questionCategory','answers', 'evaluation'])->where('id', $id)
            ->whereHas('survey', function ($query) {
            $query->where('name', $this->survey);
        });
    
        $evaluationSurvey = $evaluationSurvey->first();

        return $evaluationSurvey;

    }
}
