<?php

namespace App\Repositories\Category;

use App\Models\Category;

class CategoryRepositoryImpl implements CategoryRepository
{
    public function getAll() 
    {
        return Category::all();
    }

    public function paginate($limit = null, $columns = ['*'])
    {
        return Category::paginate($limit, $columns);
    }
    

    public function getById($id) 
    {
        return Category::findOrFail($id);
    }

    public function delete($id) : string
    {
        $deleted = Category::find($id);

        if(is_null($deleted))
            throw new \Exception('Category not found.');

        $deleted->update(['active'=>false]);
        $deleted->delete();

        return  'successfully deleted';

    }

    public function create(array $details) 
    {
        return Category::create($details);
    }

    public function update($id, array $data) : string
    {
        $updated = Category::whereId($id)->update($data);

        if($updated == 0)
            throw new \Exception('Category not found.');

        return  'successfully updated';
    }

}
