<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;

// Category
use App\Repositories\Category\CategoryRepository;
use App\Repositories\Category\CategoryRepositoryImpl;
use App\Models\Category;

// Service
use App\Repositories\Service\ServiceRepository;
use App\Repositories\Service\ServiceRepositoryImpl;
use App\Models\Service;

// TypeProduct
use App\Repositories\TypeProduct\TypeProductRepository;
use App\Repositories\TypeProduct\TypeProductRepositoryImpl;
use App\Models\TypeProduct;

// TypeSkin
use App\Repositories\TypeSkin\TypeSkinRepository;
use App\Repositories\TypeSkin\TypeSkinRepositoryImpl;
use App\Models\TypeSkin;

// Product
use App\Repositories\Product\ProductRepository;
use App\Repositories\Product\ProductRepositoryImpl;
use App\Models\Product;

// Appointment
use App\Repositories\Appointment\AppointmentRepository;
use App\Repositories\Appointment\AppointmentRepositoryImpl;

// GeneralHealth
use App\Repositories\GeneralHealth\GeneralHealthRepository;
use App\Repositories\GeneralHealth\GeneralHealthRepositoryImpl;

// EvaluationSurvey
use App\Repositories\EvaluationSurvey\EvaluationSurveyRepository;
use App\Repositories\EvaluationSurvey\EvaluationSurveyRepositoryImpl;
use App\Repositories\Shared\Infrastructure\Services\Pdf\PdfRepositoryImpl;

// =========
// Shared

// Storage
use App\Repositories\Shared\Infrastructure\Services\Storage\StorageRepository;
use App\Repositories\Shared\Infrastructure\Services\Storage\StorageRepositoryImpl;

// File
use App\Repositories\Shared\Infrastructure\Services\File\FileRepository;
use App\Repositories\Shared\Infrastructure\Services\File\FileRepositoryImpl;
use App\Models\File;

// Role
use App\Repositories\Shared\Infrastructure\Services\Role\RoleRepository;
use App\Repositories\Shared\Infrastructure\Services\Role\RoleRepositoryImpl;

// Hear About Us
use App\Repositories\Shared\Infrastructure\Services\HearAboutUs\HearAboutUsRepository;
use App\Repositories\Shared\Infrastructure\Services\HearAboutUs\HearAboutUsRepositoryImpl;

// Occupation
use App\Repositories\Shared\Infrastructure\Services\Occupation\OccupationRepository;
use App\Repositories\Shared\Infrastructure\Services\Occupation\OccupationRepositoryImpl;

// User
use App\Repositories\Shared\Infrastructure\Services\User\UserRepository;
use App\Repositories\Shared\Infrastructure\Services\User\UserRepositoryImpl;


// =========


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Category
        $this->app->bind(CategoryRepository::class, function ($app) {
            return new CategoryRepositoryImpl(new Category());
        });

        // Service
        $this->app->bind(ServiceRepository::class, function ($app) {
            return new ServiceRepositoryImpl(new Service());
        });

        // TypeProduct
        $this->app->bind(TypeProductRepository::class, function ($app) {
            return new TypeProductRepositoryImpl(new TypeProduct());
        });

        // TypeSkin
        $this->app->bind(TypeSkinRepository::class, function ($app) {
            return new TypeSkinRepositoryImpl(new TypeSkin());
        });
        
        // Product
        $this->app->bind(ProductRepository::class, function ($app) {
            return new ProductRepositoryImpl(new Product(), new StorageRepositoryImpl(), new FileRepositoryImpl());
        });

        // Appointment
        $this->app->bind(AppointmentRepository::class, function ($app) {
            return new AppointmentRepositoryImpl();
        });

        // GeneralHealth
        $this->app->bind(GeneralHealthRepository::class, function ($app) {
            return new GeneralHealthRepositoryImpl();
        });

        // EvaluationSurvey
        $this->app->bind(EvaluationSurveyRepository::class, function ($app) {
            return new EvaluationSurveyRepositoryImpl(new PdfRepositoryImpl());
        });



          // ========
        // Shared

        // Role
        $this->app->bind(RoleRepository::class, function ($app) {
            return new RoleRepositoryImpl();
        });

        // Hear about us
        $this->app->bind(HearAboutUsRepository::class, function ($app) {
            return new HearAboutUsRepositoryImpl();
        });

         // Occupation
         $this->app->bind(OccupationRepository::class, function ($app) {
            return new OccupationRepositoryImpl();
        });


        // User
        $this->app->bind(UserRepository::class, function ($app) {
            return new UserRepositoryImpl();
        });
    
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
        Schema::defaultStringLength(191);

    }
}
