<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;

class Survey extends Model
{
    use HasFactory, SoftDeletes;


    protected $dates = ['deleted_at'];

    protected $fillable = [
        'category_survey_id',
        'name',
        'description',
        'icon',
        'active'
    ];


    public function categorySurvey(): BelongsTo
    {
        return $this->belongsTo(CategorySurvey::class);
    }


    public function questions(): HasMany
    {
        return $this->hasMany(Question::class);
    }

    public function questionOptions(): HasManyThrough
    {
        return $this->hasManyThrough(QuestionOption::class, Question::class);
    }


}
