<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Carbon\Carbon;

class Service extends Model
{
    use HasFactory, SoftDeletes;

    protected $dates = ['deleted_at'];

    protected $fillable = [
        'category_id',
        'name',
        'observation',
        'price',
        'duration',
        'additional_time',
        'active'
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

    protected function duration(): Attribute
    {
        return Attribute::make(
            get: fn (mixed $value) =>  Carbon::parse($value)->format('H:i') 
        );
    }

    protected function additionalTime(): Attribute
    {
        return Attribute::make(
            get: fn (mixed $value) =>  Carbon::parse($value)->format('H:i') 
        );
    }

    public function surveys(): BelongsToMany
    {
        return $this->belongsToMany(Survey::class);
    }
}
