<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class QuestionOption extends Model
{
    use HasFactory, SoftDeletes;


    protected $dates = ['deleted_at'];

    protected $fillable = [
        'question_id',
        'question_option',
        'required_answer',
        'risk',
        'active'
    ];

    public function survey(): BelongsTo
    {
        return $this->belongsTo(Survey::class);
    }


    public function questionOptions(): HasMany
    {
        return $this->hasMany(QuestionOption::class);
    }
}
