<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Question extends Model
{
    use HasFactory, SoftDeletes;


    protected $dates = ['deleted_at'];

    protected $fillable = [
        'survey_id',
        'question',
        'question_category_id',
        'type_input',
        'order',
        'active'
    ];

    public function survey(): BelongsTo
    {
        return $this->belongsTo(Survey::class);
    }

    public function questionCategory(): BelongsTo
    {
        return $this->belongsTo(QuestionCategory::class);
    }


    public function questionOptions(): HasMany
    {
        return $this->hasMany(QuestionOption::class);
    }

    public function answers(): HasMany
    {
        return $this->hasMany(Answer::class);
    }

    // public static function answers($id)
    // {
    //     $pageWidget = Answer::where('evaluation_survey_id', '=', $id)
    //                 ->get();

    //     return $pageWidget;
    // }

}
