<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;


class Product extends Model
{
    use HasFactory, SoftDeletes;

    protected $dates = ['deleted_at'];

    protected $fillable = [
        'name',
        'type_product_id',
        'description',
        'active'
    ];


    public function TypeSkins()
    {
        return $this->belongsToMany(TypeSkin::class, 'products_skins');
    }

    public function TypeProduct(): BelongsTo
    {
        return $this->belongsTo(TypeProduct::class);
    }

    public function Files(): HasMany
    {
        return $this->hasMany(File::class, 'table_id', 'id')->where('table_name', 'products')->select('id', 'name', 'table_name', 'table_id');
    }

}
