<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;

class EvaluationSurvey extends Model
{
    use HasFactory;

    protected $fillable = [
        'general_health_id',
        'evaluation_id',
        'survey_id',
        'completed_by',
        'status'
    ];

    public function general_health(): BelongsTo
    {
        return $this->belongsTo(EvaluationSurvey::class, 'general_health_id', 'id');
    }
    
    public function evaluation(): BelongsTo
    {
        return $this->belongsTo(Evaluation::class);
    }

    public function survey(): BelongsTo
    {
        return $this->belongsTo(Survey::class);
    }

    public function completed_by(): BelongsTo
    {
        return $this->belongsTo(User::class, 'completed_by', 'id');
    }

    public function answers(): HasMany
    {
        return $this->hasMany(Answer::class);
    }

    public function files(): HasMany
    {
        return $this->hasMany(File::class, 'table_id', 'id')->where('table_name', 'evaluation_surveys')->select(['name','table_id', ]);
    }

}
