<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Carbon\Carbon;

class Appointment extends Model
{
    use HasFactory, SoftDeletes;


    protected $dates = ['deleted_at'];

    protected $fillable = [
        'employee_id',
        'client_id',
        'service_id',
        'deleted_by',
        'start_time',
        'finish_time',
        'status',
        'comments'
    ];
    protected $appends = [
        'appointment', 'cancel'
    ];


    protected function appointment(): Attribute
    {
        return Attribute::make(
            get: fn (mixed $value, array $attributes) =>  Carbon::parse($attributes['start_time'])->format('d/m/y H:i') . ' - ' . 
            Carbon::parse($attributes['finish_time'])->subHour(Carbon::parse($this->service->additional_time)->format('H'))->subMinutes(Carbon::parse($this->service->additional_time)->format('i'))->format('H:i')
        );
    }

    protected function cancel(): Attribute
    {
        return Attribute::make(
            // get: fn (mixed $value, array $attributes) =>  Carbon::now()->diffInHours(Carbon::parse($attributes['start_time']))
            // get: fn (mixed $value, array $attributes) =>  Carbon::parse($attributes['start_time'])->isPast(Carbon::now())
            get: fn (mixed $value, array $attributes) =>  (!(Carbon::parse($attributes['start_time'])->isPast(Carbon::now())) && (Carbon::now()->diffInHours(Carbon::parse($attributes['start_time'])) >= 24))

        );
        
    }

    public function employee(): BelongsTo
    {
        return $this->belongsTo(User::class, 'employee_id', 'id');
    }

    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class, 'service_id', 'id');
    }

    public function client(): BelongsTo
    {
        return $this->belongsTo(User::class, 'client_id', 'id');
    }

}
