<?php

namespace App\Http\Requests\User;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Validation\Rule;
use App\Enums\Gender;

class UpdateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {


        return [
            'name' => 'required|string|max:100',
            'lastname' => 'required|string|max:100',
            'date_birth' => 'date|before:today',
            'identification' => ['required', 'digits_between:10,10',
            'unique:users,identification,' .$this->id . ',id'],

            'email' => 'required|email:rfc,dns|unique:users,email,' . $this->id, ',id',
            'role_id' => ['required',Rule::exists('roles', 'id')],
            'occupation_id' => ['nullable', Rule::exists('occupations', 'id')],
            'hear_about_us_id' => ['nullable', Rule::exists('hear_about_us', 'id')],
            'mobile' => 'nullable|doesnt_start_with:1,2,3,4,5,6,7,8,9|numeric|digits:10',
            'telephone' => 'nullable|numeric|digits:10',
            'gender'=> Rule::enum(Gender::class)

        ];
    }


    public function failedValidation(Validator $validator)

    {

        throw new HttpResponseException(response()->json([

            'success'   => false,
            'message'   => 'Validation errors',
            'data'      => $validator->errors()
        ]));

    }
}
