<?php

namespace App\Http\Requests\TypeSkin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Validation\Rule;

class StoreTypeSkinRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    
    public function rules(): array
    {
        return [
            'name' => 'required|string|unique:type_skins|max:100',
            'active' => 'boolean',
        ];
    }

    public function failedValidation(Validator $validator)

    {

        throw new HttpResponseException(response()->json([

            'success'   => false,
            'message'   => 'Validation errors',
            'data'      => $validator->errors()
        ]));

    }
}
