<?php

namespace App\Http\Requests\Product;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\File;

class StoreProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name'            => 'required|string|max:100',
            'description'     => 'string|max:1000',
            'type_product_id' => ['required',Rule::exists('type_products', 'id')->whereNull('deleted_at')->where('active', true)],
            'type_skin_id'    => 'required|array',
            'type_skin_id.*'  => ['required', Rule::exists('type_skins', 'id')->whereNull('deleted_at')->where('active', true)],
            'files'           => 'required|array',
            'files.*'         =>   ['required', 'distinct', File::image()->min(1)->max(10 * 1024)]//       ->dimensions(Rule::dimensions()->maxWidth(1000)->maxHeight(500)),
            
                        
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(response()->json([
            'success'   => false,
            'message'   => 'Validation errors',
            'data'      => $validator->errors()
        ]));
    }
}
