<?php

namespace App\Http\Requests\GeneralHealth;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use App\Enums\Status;
use App\Enums\SurveyName;
use App\Rules\CorrectQuestionOptionForQuestion;
use App\Rules\CorrectQuestionForSurvey;

class StoreGeneralHealthRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */

    public function rules(): array
    {
        return [
            'survey_id' => ['required', Rule::exists('surveys', 'id')->where('name', SurveyName::GENERAL_HEALTH)->where('active', true)],
            'evaluation_id' => ['required', Rule::exists('evaluations', 'id')->where('table_name', 'users')->where('status', Status::PENDING)],
            'evaluation_survey_id' => ['required', Rule::exists('evaluation_surveys', 'id')->where('survey_id', $this->survey_id)->where('evaluation_id', $this->evaluation_id)],
            'answers'  => ['required', 'array',],
            'answers.*.question_id'  => ['required',  new CorrectQuestionForSurvey($this->survey_id)],
            'answers.*.question_option_id'  => ['required', new CorrectQuestionOptionForQuestion($this->answers), 'distinct'],
            'answers.*.answer' => ['nullable', 'string']
        ];
    }
}
