<?php

namespace App\Http\Requests\GeneralHealth;

use Illuminate\Foundation\Http\FormRequest;
use App\Rules\NotExistPendingGeneralHealth;
use Illuminate\Validation\Rule;

class GenerateGeneralHealthRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'user_id' => ['required', Rule::exists('users', 'id')->whereNull('deleted_at')->where('active', true), new NotExistPendingGeneralHealth()]
        ];
    }
}
