<?php

namespace App\Http\Requests\Appointment;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreAppointmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'start_time' => 'required|date|after:now',
            // 'finish_time' => 'required|date|after:now',
            'client_id' => ['nullable', Rule::exists('users', 'id')->whereNull('deleted_at')->where('active', true)],
            'service_id' => ['required', Rule::exists('services', 'id')->whereNull('deleted_at')->where('active', true)],

        ];
    }

    public function messages()
    {
        return ['start_time.after' => 'Horario no disponible'];
    }
}
