<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Shared\Infrastructure\Services\Pdf\PdfRepositoryImpl;
use App\Models\EvaluationSurvey;
use App\Models\User;
use App\Models\File;
use App\Enums\Status;

class PDFController extends Controller
{
    public function generatePDF()
    {

        $evaluation_survey = EvaluationSurvey::with(['survey.questions.questionOptions','survey.questions.questionCategory','answers', 'evaluation', 'completed_by', 'files'])
        ->where('id', 2)->first(); //dd($evaluation_survey->toArray());

        $user = User::with('Occupation', 'HearAboutUs')->find($evaluation_survey->evaluation->table_id);
        $clientId = $user->id;
        $evaluation_survey['client'] = $user->toArray();

        $general_health = EvaluationSurvey::with(['survey.questions.questionOptions','survey.questions.questionCategory','answers', 'evaluation', 'completed_by'])
            ->where('status', Status::PROCESSED)
            ->where('survey_id', 1)
            ->whereHas('evaluation', function ($query) use ($clientId){
                $query->where('table_name', 'users');
                $query->where('table_id', $clientId);
            })
            ->latest()->first()->toArray();

        $evaluation_survey['general_health'] = $general_health;dd($evaluation_survey->toArray());
        return PdfRepositoryImpl::generateEvaluationSurveyPdf($evaluation_survey);   
    }

    public function getPdf($name)
    {
        $file = File::where('name', $name . '.pdf')->first();
        
        if(is_null($file))
            return response()->json([], 404);

        return PdfRepositoryImpl::getPdfEvaluationSurvey($file);
        
    }
}
