<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\TypeSkin\StoreTypeSkinRequest;
use App\Http\Requests\TypeSkin\UpdateTypeSkinRequest;
use App\Repositories\TypeSkin\TypeSkinRepository;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Response;

class TypeSkinController extends Controller
{
    private TypeSkinRepository $typeSkinRepository;

    public function __construct(TypeSkinRepository $typeSkinRepository)
    {
        $this->typeSkinRepository = $typeSkinRepository;
    }
    
    public function index($limit = 10)
    {
        
        try {
            return response()->json([
                'error' => false,
                'data' => $this->typeSkinRepository->paginate($limit),
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreTypeSkinRequest $request)
    {
        $data = $request->validated();

        return response()->json([
            'error' => false,
            'data' => $this->typeSkinRepository->create($data),
        ],
            Response::HTTP_CREATED
        );
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateTypeSkinRequest $request, string $id): JsonResponse
    {
        try {
            $data = $request->validated();

            return response()->json([
                'error' => false,
                'data' => $this->typeSkinRepository->update($id, $data),
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);

        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id): JsonResponse
    {
        try {
            $this->typeSkinRepository->delete($id);

            return response()->json(null, Response::HTTP_NO_CONTENT);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }
}
