<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\TypeProduct\StoreTypeProductRequest;
use App\Http\Requests\TypeProduct\UpdateTypeProductRequest;
use App\Repositories\TypeProduct\TypeProductRepository;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Response;

class TypeProductController extends Controller
{
    private TypeProductRepository $typeProductRepository;

    public function __construct(TypeProductRepository $typeProductRepository)
    {
        $this->typeProductRepository = $typeProductRepository;
    }
    
    public function index($limit = 10)
    {
        
        try {
            return response()->json([
                'error' => false,
                'data' => $this->typeProductRepository->paginate($limit),
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreTypeProductRequest $request)
    {
        $data = $request->validated();

        return response()->json([
            'error' => false,
            'data' => $this->typeProductRepository->create($data),
        ],
            Response::HTTP_CREATED
        );
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateTypeProductRequest $request, string $id): JsonResponse
    {
        try {
            $data = $request->validated();

            return response()->json([
                'error' => false,
                'data' => $this->typeProductRepository->update($id, $data),
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);

        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id): JsonResponse
    {
        try {
            $this->typeProductRepository->delete($id);

            return response()->json(null, Response::HTTP_NO_CONTENT);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }
}
